uniform sampler2DRect maskTex;
uniform vec2 maskSize;
uniform vec4 blends;
uniform float centerLuminance;
uniform float power;
uniform float gamma;
varying vec2 positionInInsetSurface;
varying vec2 positionInFacet;

void main()
{
    if ( positionInInsetSurface.x < 0.0 || positionInInsetSurface.y < 0.0 || positionInInsetSurface.x > 1.0 || positionInInsetSurface.y > 1.0 )
    {
        gl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );
    }
    else if ( positionInFacet.x < 0.0 || positionInFacet.y < 0.0 || positionInFacet.x > 1.0 || positionInFacet.y > 1.0 )
    {
        gl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );
    }
    else
    {
        float progress = 1.0;
        if ( positionInFacet.x < blends[3] )    // left
            progress = positionInFacet.x / blends[3];
        else if ( positionInFacet.x > 1.0 - blends[1] ) // right
            progress = (1.0 - positionInFacet.x) / ( blends[1] );
        if ( positionInFacet.y < blends[2] )
            progress *= positionInFacet.y / blends[2]; // bottom
        else if ( positionInFacet.y > 1.0 - blends[0] )
            progress *= (1.0 - positionInFacet.y) / ( blends[0] ); // top
        
        progress = progress < 0.5 ? centerLuminance * pow(2. * progress, power) : 1.0 - (1.0 - centerLuminance) * pow(2. * (1. - progress), power);
     
        vec4 mask;
        if ( maskSize.x > 0.0 )
            mask = texture2DRect( maskTex, vec2( gl_TexCoord[0].x * maskSize.x, ( 1.0 - gl_TexCoord[0].y ) * maskSize.y ) );
        else
            mask = vec4( 1.0, 1.0, 1.0, 1.0 );

        float blendAlpha;
        if ( gamma < 0.1 )
            blendAlpha = 1.0;
        else
            blendAlpha = pow(progress, 1. / gamma);
        gl_FragColor = vec4( gl_TexCoord[0].x, gl_TexCoord[0].y, blendAlpha * 0.3333 * mask.a * ( mask.r + mask.g + mask.b ), 1.0 );
    }
}